#         Remember to "Download All"!
# 
# After "Loading" a floppy, or multiple floppies,
# you must click on "Download All" to download
# the loaded images to the physical SVD.
# 
# IMPORTANT - whenever you download the the SVD,
# the previous images on the physical SVD are
# erased.  Even if you are downloading disk 1,
# and disk 2 is currently on the physical SVD,
# ALL images on the SVD will be erased before
# disk 1 is downloaded...including disk 2.
# 
# If the floppy image has changed since downloading
# due to a write to the physical SVD image, you
# should "Upload" it before downloading new image(s).
# 
#       [] Don't show this tip again

image create photo infoIcon -file [file join $home tips.gif]

########################################################################
# tipsShowDialogCreate() -	Creates the "Show Tips..." dialog.
########################################################################
proc tipsShowDialogCreate {} {
    set width 4i

    iwidgets::dialogshell .tipshow -title "All SVD Tips" -master .
    .tipshow configure -modality application
    .tipshow add dismiss -text "Dismiss" -command { 
	.tipshow deactivate 
    }
    .tipshow default dismiss

    set main [.tipshow childsite]

    iwidgets::Labeledframe $main.container -labelpos nw -labeltext "All SVD Tips"
    set container [$main.container childsite]

    iwidgets::Labeledframe $main.search -labelpos nw -labeltext "Search SVD Tips"
    set search [$main.search childsite]

####### here is the list box

    frame $container.frame -borderwidth 10

    scrollbar $container.frame.yscroll -command "$container.frame.list yview"
    scrollbar $container.frame.xscroll -orient horizontal \
	    -command "$container.frame.list xview"
    listbox $container.frame.list -width 40 -height 10 -setgrid 1 \
	    -selectmode single \
	    -yscroll "$container.frame.yscroll set" \
            -xscroll "$container.frame.xscroll set" \
	    -background white

    grid $container.frame.list -row 0 -column 0 \
	    -rowspan 1 -columnspan 1 -sticky news
    grid $container.frame.yscroll -row 0 -column 1 \
	    -rowspan 1 -columnspan 1 -sticky news
    grid $container.frame.xscroll -row 1 -column 0 \
	    -rowspan 1 -columnspan 1 -sticky news
    grid rowconfig    $container.frame 0 -weight 1 -minsize 0
    grid columnconfig $container.frame 0 -weight 1 -minsize 0

    bind $container.frame.list <Double-Button-1> [list $container.show.go invoke]

    frame $container.show

    button $container.show.go -text "Show..." -command { 
        set main [.tipshow childsite]
	set container [$main.container childsite]
	set target [$container.frame.list get [$container.frame.list curselection]]
	tipsDialogShowByTitle $target
    }

    message $container.show.message -text "Click on a tip then click \"Show\"" -width 400 -justify right

    pack $container.show.message -side left -padx 3 -pady 3
    pack $container.show.go -side right -padx 3 -pady 3 -fill x -expand yes

#
# the search term entry field
#
    iwidgets::entryfield $search.searchterm -highlightthickness 0 -width 30 \
	    -labelpos w -labeltext "Search for:" -textbackground "white" -command [list $search.go invoke]

    [$search.searchterm component label] configure -justify right -underline 0

    button $search.go -text "Search..." -command { 
        set main [.tipshow childsite]
	set search [$main.search childsite]
	set searchterm [$search.searchterm get]

	[[.tipsearch childsite].container childsite].frame.list delete 0 end

	set allTips [iniEnumerateSection "Tips"]

	set count 0
	foreach tip $allTips {
	    if { [string match -nocase [format "*%s*" $searchterm] $tip] } {
		regexp {^([^ ]*) (.*)$} $tip dummy attribute value
		set value [subst -nocommands -novariables $value]
		regexp {([^\n]*)\n(.*)} $value all title body
		[[.tipsearch childsite].container childsite].frame.list insert end $title
		incr count
	    }
	}

	if { $count } {
	    .tipsearch activate
	} else {
	    tk_messageBox -default ok -icon info -title "Notice" -type ok -message \
		    "Nothing found with that search term."
	}
    }

    pack $search.searchterm -side left -anchor w -pady 3
    pack $search.go -side left -anchor w -padx 3 -pady 3

### pack it all in there

    pack $container.frame -side top -expand no -fill y
    pack $container.show -side bottom

    pack $main.container -side top -expand yes -fill x
    pack $main.search -side top -expand yes -fill x

#
# go ahead and put all of the tips into the list box
#
    set allTips [iniEnumerateSection "Tips"]

    foreach tip $allTips {
	regexp {^([^ ]*) (.*)$} $tip dummy attribute value
	set value [subst -nocommands -novariables $value]
	regexp {([^\n]*)\n(.*)} $value all title body
	$container.frame.list insert end $title
    }

    return
}

########################################################################
# tipsSearchDialogCreate() -	Creates the "Search Tips..." dialog.
########################################################################
proc tipsSearchDialogCreate {} {
    set width 300

    iwidgets::dialogshell .tipsearch -title "SVD Tip Search Results" -master .
    .tipsearch configure -modality application
    .tipsearch add dismiss -text "Dismiss" -command { 
	.tipsearch deactivate 
    }
    .tipsearch default dismiss

    set main [.tipsearch childsite]

    iwidgets::Labeledframe $main.container -labelpos nw -labeltext "SVD Tip Search Results"
    set container [$main.container childsite]

####### here is the list box

    frame $container.frame -borderwidth 10

    scrollbar $container.frame.yscroll -command "$container.frame.list yview"
    scrollbar $container.frame.xscroll -orient horizontal \
	    -command "$container.frame.list xview"
    listbox $container.frame.list -width 40 -height 10 -setgrid 1 \
	    -selectmode single \
	    -yscroll "$container.frame.yscroll set" \
            -xscroll "$container.frame.xscroll set" \
	    -background white

    grid $container.frame.list -row 0 -column 0 \
	    -rowspan 1 -columnspan 1 -sticky news
    grid $container.frame.yscroll -row 0 -column 1 \
	    -rowspan 1 -columnspan 1 -sticky news
    grid $container.frame.xscroll -row 1 -column 0 \
	    -rowspan 1 -columnspan 1 -sticky news
    grid rowconfig    $container.frame 0 -weight 1 -minsize 0
    grid columnconfig $container.frame 0 -weight 1 -minsize 0

    bind $container.frame.list <Double-Button-1> [list $container.show.go invoke]

    frame $container.show

    button $container.show.go -text "Show..." -command { 
        set main [.tipsearch childsite]
	set container [$main.container childsite]
	set target [$container.frame.list get [$container.frame.list curselection]]
	tipsDialogShowByTitle $target
    }

    message $container.show.message -text "Click on a tip then click \"Show\"" -width 400 -justify right

    pack $container.show.message -side left -padx 3 -pady 3
    pack $container.show.go -side right -padx 3 -pady 3 -fill x -expand yes

### pack it all in there

    pack $container.frame -side top -expand no -fill y
    pack $container.show -side bottom

    pack $main.container -side top -expand yes -fill x

    return
}


########################################################################
# tipsDialogCreate() -	Create the tips dialog used when presenting the
#                       Tips.
########################################################################
proc tipsDialogCreate {} {
    global tipOff

    set width [iniGetAttribute "Font" "TipsWidth"]

    iwidgets::dialogshell .tips -title "SVD Tips" -master .

    .tips configure -modality application
    .tips add OK -text "OK" -command { 
	set tip [[.tips childsite].tip cget -text]
	if { $tipOff } {
	    iniSetAttribute "Tip-Control" $tip 1
	}
	.tips deactivate 
    }
    .tips add next -text "Next Tip" -command {
	set tip [[.tips childsite].tip cget -text]
	if { $tipOff } {
	    iniSetAttribute "Tip-Control" $tip 1
	}
	tipsDialogShow "General"
    }

    .tips default OK

    set working [.tips childsite]

    #
    # the text in these two widgets here never gets displayed, it is just
    # a place holder to make it size well for positioning
    #
    message $working.text -highlightthickness 0 -width $width \
	    -font [iniGetAttribute "Font" "Tips"] \
	    -text "this is a test that goes on and on and on and on.this is a test that goes on and on and on and on.this is a test that goes on and on and on and on.this is a test that goes on and on and on and on.this is a test that goes on and on and on and on.this is a test that goes on and on and on and on."

    message $working.title -highlightthickness 0 -width $width -anchor w \
	    -font [iniGetAttribute "Font" "TipsTitle"] \
	    -text "Remember to \"Download All\""

    #
    # this field is simply to hold the "tip" name - it doesn't show up anywhere
    #			     
    message $working.tip -text ""

    checkbutton $working.check -highlightthickness 0 -anchor n -justify center \
	    -underline 0 -variable tipOff -onvalue 1 -offvalue 0 -text "Do not show this tip again" 

    set bg [$working cget -background]
    canvas $working.bitmap -width 42 -height 42 -highlightthickness 0 -background $bg

    $working.bitmap create image 0 0 -anchor nw -image infoIcon

    pack $working.bitmap -anchor n -side left -expand no
    pack $working.title -anchor w -side top -pady 10
    pack $working.text -anchor w -side top -expand yes -fill x
    pack $working.check -anchor s -side bottom -pady 10 -expand yes

    update

    set newx [expr [winfo x .] + ([winfo width .]/2) - ([winfo width .tips] / 2)]
    set newy [expr [winfo y .] + ([winfo height .]/2) - ([winfo height .tips] / 2)]

    wm geometry .tips [format "+%d+%d" $newx $newy]
}

########################################################################
# tipsNextEnabled() -	Given a tip number, return the number of the
#                       next enabled tip, or 0 if none past $num is enabled.
########################################################################
proc tipsNextEnabled {tips num} {
    set length [llength $tips]

    for { incr num } { $num < $length } { incr num } {
	regexp {^([^ ]*) (.*)$} [lindex $tips $num] dummy thistip text
	set tipcontrol [iniGetAttribute "Tip-Control" $thistip]
	
	if { $tipcontrol == "" || $tipcontrol != 1 } {
	    return $num
	}
    }

    return 0
}

########################################################################
# tipsDialogShowByTitle() -	Show the tip given its title.
#                               Will show the tip, even if it has been
#                               disabled.  If it HAS been disabled, then
#                               the checkbox will be pre-checked.
########################################################################
proc tipsDialogShowByTitle {target} {

    set allTips [iniEnumerateSection "Tips"]

    foreach tip $allTips {
	regexp {^([^ ]*) (.*)$} $tip dummy thistip value
	set value [subst -nocommands -novariables $value]
	regexp {([^\n]*)\n(.*)} $value all title body
	if { [string equal $title $target] } {
	    if { ! [tipsDialogShow $thistip] } {
		iniDelAttribute "Tip-Control" $thistip
		tipsDialogShow $thistip 1
	    }
	    return 1
	}
    }
    return 0
}

########################################################################
# tipsDialogShow() -	Show the given tip.
#                       Will "turn-off" the tip if requested.
########################################################################
proc tipsDialogShow {tip {checkdefault 0}} {
    global tipOff

    set tipcontrol [iniGetAttribute "Tip-Control" $tip]

    if { $tipcontrol != "" && $tipcontrol == 1 } {
	return 0
    }

    if { $tip == "Welcome" } {
	set checkboxtext "Don't show welcome message again"
    } elseif { $tip == "Startup" } {
	set checkboxtext "Don't show start-up tips again"
    } else {
	set checkboxtext "Don't show this tip again"
    }

    set working [.tips childsite]

    if { $tip == "Startup" || $tip == "General" } {

	set allTips [iniEnumerateSection "Tips"]
	set lastTip [iniGetAttribute "Tip-Control" "LastTip"]

	# it is assumed that the Welcome tip is tip 0

	if { $lastTip == "" } {
	    set lastTip 0
	}

	set nextTip [tipsNextEnabled $allTips $lastTip]
	if { $nextTip == 0 } {
	    set nextTip [tipsNextEnabled $allTips 0]
	    if { $nextTip == 0 } {
		.tips deactivate
		tk_messageBox -default ok -icon info -title "Notice" -type ok -message \
			"All tips have been disabled."
		return 0
	    }
	}

	regexp {^([^ ]*) (.*)$} [lindex $allTips $nextTip] dummy thistip text
	iniSetAttribute "Tip-Control" "LastTip" $nextTip

    } else {
	set text [iniGetAttribute "Tips" $tip]
    }

    set text [subst -nocommands -novariables $text]
    if { $text != "" } {
	regexp {([^\n]*)\n(.*)} $text all title body

	$working.title configure -text $title
	$working.text configure -text $body
	$working.check configure -text $checkboxtext
	if { $tip == "General" } {
	    $working.tip configure -text $thistip
	} else {
	    $working.tip configure -text $tip
	}

	set tipOff $checkdefault

	.tips activate
    }

    return 1
}

########################################################################
# tipsReset() -	Reset the tips making them all show again...including
#               the nice "Welcome" message!
########################################################################
proc tipsReset {} {

    set answer [tk_messageBox -default no -icon warning -title "WARNING"  \
	    -type yesno -parent . -message \
"Are you sure you want to reset all of
SVD Tips (display them ALL again)?"]

    if { $answer != "yes" } {
	    return
    }

    foreach attributevalue [iniEnumerateSection "Tip-Control"] {
	regexp {^([^ ]*) (.*)$} $attributevalue dummy attribute value
	iniDelAttribute "Tip-Control" $attribute
    }
}
